﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using VIRP_WEB.BaseCode;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Custom.BCR
{
    public partial class Default : BasePage
    {
        private List<ReportItem> ReportItems
        {
            get
            {
                List<ReportItem> reportItems = null;

                if (ViewState["ReportItems"] == null)
                {
                    reportItems = ServiceInterfaceManager.REPORTS_GET_ALL_BY_USER_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    reportItems = reportItems.Where(x => x.ReportStore == "BCR").ToList();
                    ViewState["ReportItems"] = reportItems;
                }
                else
                {
                    reportItems = ViewState["ReportItems"] as List<ReportItem>;
                }

                return reportItems;
            }
            //set
            //{
            //    ViewState["ReportItems"] = value;
            //}
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
                ServiceInterfaceManager.LogInformation("PAGE_LOAD", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                base.Page_Load(sender, e);

                lblResult.Text = string.Empty;

                if (UserSession == null || UserSession.CurrentRegistryId <= 0)
                {
                    Response.Redirect("~/Default.aspx", false);
                }
                else
                {
                    if (!Page.IsPostBack)
                    {
                        List<ReportItem> reports = ReportItems;

                        gridStandardReports.DataSource = reports.Where(x => x.Name.ToLower().Contains("standard report")).ToList();
                        gridStandardReports.DataBind();

                        gridAggregateReports.DataSource = reports.Where(x => x.Name.ToLower().Contains("aggregate report")).ToList();
                        gridAggregateReports.DataBind();

                        gridAdHocReports.DataSource = reports.Where(x => x.Name.ToLower().Contains("ad hoc report")).ToList();
                        gridAdHocReports.DataBind();

                        gridUtilityReports.DataSource = reports.Where(x => x.Name.ToLower().Contains("utility")).ToList();
                        gridUtilityReports.DataBind();

                        SetMenu();
                    }
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void SetMenu()
        {
            Menu topMenu = this.Master.FindControl("mnuTopMenu") as Menu;
            if (topMenu != null)
            {
                if (topMenu.Items != null)
                {
                    if (topMenu.Items.Count > 0)
                    {
                        foreach (MenuItem mi in topMenu.Items)
                        {
                            if (mi.Text == "Help")
                                mi.NavigateUrl = "~/Custom/BCR/Help/reports_dashboard.html";
                        }
                    }
                }
            }
        }
    }
}